/**************************************************
PARABOLA

Plot a parabola on the screen...

This program is a demo of how to use GRAFXY.H

Developed by:

	JOSE LUIS DE LA CRUZ LAZARO
	contact@theworldofchaos.com

	YACSHA - Software & Desing, since 1999, Lima-Peru
	>> The World of Chaos - EL MUNDO DEL CAOS - Unlimited Programming
	www.theworldofchaos.com

LICENSE
	This file is released under the terms of the BSD 3-Clause License.
	Read LICENSE.txt file for more information.

HISTORY...

 >> Version 2 - 21-III-2024
	- Update graphics/gxydemo - Porting to VC++ 2017 using winbgi

***************************************************/

#define _CRT_SECURE_NO_WARNINGS
#include "graphics.h"

//#include <conio.h> //getch()
#include "grafxy.h"

using namespace std;

int main()
{
	//se ingresa como argumento la ruta de la carpeta bgi
	//autoini("");//inicia el modo grafico, por defecto 16 colores
	initwindow(1024, 768, "The World of Chaos");


	//se declara la regin donde se graficar la funcin
	CRegionXY Region(-5,   //x mnimo
		5,   //x mximo
		-3,  //y mnimo
		3); //y mximo

	double x, //variable independiente
		dx = 0.01; //particin mas pequea de x

	Region.Ejes(); //grafica los ejes coordenados

	//se varia x desde su valor mnimo a su mximo, con una particin de dx
	for (x = Region.xmin(); x < Region.xmax(); x += dx)
		//grafica un punto de la funcin
		Region.punto(x, // variable independiente
			x*x, //funcin f(x) a graficar (para este caso es una parbola )
			LIGHTGREEN, //color del trazo (verde claro)
			CONECTAR); //argumento opcional; CONECTAR=conectar los puntos de la grfica, si no se ingresa este argumento no se conecta los puntos

	getch();//pone una pausa

	closegraph();//cierra el modo grfico

	return 1;
}