#pragma once
/***********************************************************************************
 :: CMATRIX :::
 -- ALGEBRA OF MATRIXES -- ALGEBRA DE MATRICES --

 This class provides elementary operations between matrices, such as the addition
 of matrices, difference of matrices, negative of a matrix, multiplication of a
 scalar by a matrix and multiplication of matrices. In addition to providing methods
 to calculate the determinant, the inverse matrix, and the transposed matrix
 
 Esta clase provee de operaciones elementales entre matrices, como la suma de
 matrices, diferencia de matrices, negativo de una matriz, multiplicacin de un
 escalar por una matriz y multiplicacin de matrices. Adems de que provee
 de mtodos para calcular el determinante, la matriz inversa, y la matriz transpuesta.

Developed by:

	JOSE LUIS DE LA CRUZ LAZARO
	contact@theworldofchaos.com

	YACSHA - Software & Desing, since 1999, Lima-Peru
	>> The World of Chaos - EL MUNDO DEL CAOS - Unlimited Programming
	www.theworldofchaos.com

LICENSE
	This file is released under the terms of the BSD 3-Clause License.
	Read LICENSE.txt file for more information.

HISTORY...

 >> Version 2 - 29-IV-2024
	- Update math-and-others\cmatrix - Porting to VC++ 2017
	- Merge cmatriz4, matrices and matripak in cmatrix
	- Separate the CMatrix class into .h and .cpp files
	- Rename class CMatriz for CMatrix
	- Update to C++17, using std::vector instead of old arrays
	- In the CMatrix class, the DetCofact, InvCofact and InvGauss methods are added;
	  to calculate the determinant by the cofactor method; Inverse of a matrix by the
	  cofactor method and inverse of a matrix by the Gauss-Jordan method
	- The methods of overloaded algebraic operators are corrected, defining their
	  parameters as constants. Likewise, several methods are corrected, indicating
	  which are constants and which have constant parameters.
	- The Transposed method is added to calculate the matrix transposed to the
	  original.
	- The InvGauss and InvCofact methods now return a boolean indicating whether the
	  inversion was performed successfully, so that the user can take action in cases
	  where the matrix is not invertible.
	- The Initialize method is eliminated, since now the initialization is done with
	  the standard resize method of std::vector
	- The EnterElements and Write methods are removed from the CMatrix library, so as
	  not to mix the functions of the view (in this case the console) with the domain
	  (CMatrix library), so that the CMatrix library can be used in multiple views,
	  which will not necessarily be the console
	- The IngresarElementos and Escribir methods are declared as global functions in the
	  example.cpp file, to enter the data of the array
	- The InvGauss method of CMatriz 1.4 is renamed to InvGaussJordan2
	- The InvGaussJordan1 method is added, which was an independent program that
	  now integrates the CMatrix library
	- The InvGaussJordan3 method is added, which was an independent program that
	  now integrates the CMatrix library. This program is added in conjunction
	  with the private step and reverse methods, which are recursive functions
	  that are invoked by InvGaussJordan3.
	- Now the methods InvGaussJordan2 and InvGaussJordan3 allow you to simultaneously
	  calculate the inverse matrix and the determinant of the original matrix
	- Some bugs are corrected in InvGaussJordan2, InvGaussJordan3, which did not allow
	  the correct calculation of the inverse matrix and a consistency validation of
	  the diagonal of the pivoted matrix G (left G) is also added, in such a way that
	  no element of the diagonal of G left must be zero, otherwise the matrix is not
	  invertible. In this way, these functions return a boolean indicating whether the
	  calculation of the inverse matrix could be carried out.
	- The private IsZero method is added, using a small delta, to check if a variable
	  is zero, since previously the operator X==0 was used to check if a variable is
	  zero, which could give unexpected results.
	- Version history and credits are updated.
	- Translations from Spanish to English are added to the version history
	- Obsolete files are removed
	- Some methods and member variables are translated from Spanish to English
	- Bug is corrected in the calculation of the sign of the determinant in the
	  InvGaussJordan2 and InvGaussJordan3 methods
	- The default commented example of the CMatrix class has been removed, as it has
	  become obsolete. We suggest seeing the example.cpp file, to see a complete example
	  on the use of CMatrix

	 Spanish:
	- Se actualiza math-and-others\cmatrix - Se hace el porting a VC++ 2017
	- Se fusionan los proyectos cmatriz4, matrices y mattripak en cmatrix
	- Se separa la clase CMatrix en archivos .h y .cpp
	- Se cambia el nombre de la clase CMatriz por CMatrix
	- Actualizacin a C++ 17, usando std::vector en lugar de los viejos arrays
	- En la clase CMatrix se agregan los mtodos DetCofact, InvCofact e InvGauss;
	  calcular el determinante mediante el mtodo del cofactor;
	  Inversa de una matriz por el mtodo del cofactor e inversa de una matriz por
	  el mtodo de Gauss-Jordan
	- Se corrigen los mtodos de operadores algebraicos sobrecargados, definiendo sus
	  parmetros como constantes. Asimismo, se corrigen varios mtodos, indicando cules
	  son constantes y cules tienen parmetros constantes.
	- Se agrega el mtodo Transpuesto para calcular la matriz transpuesta al original.
	- Los mtodos InvGauss e InvCofact ahora devuelven un booleano que indica si la
	  inversin se realiz exitosamente, para que el usuario pueda tomar medidas en los
	  casos en que la matriz no sea invertible.
	- Se elimina el mtodo Inicializar, ya que ahora la inicializacin se hace con el
	  mtodo estandar resize de std::vector
	- Se remueve de la libreria CMatrix los mtodos IngresarElementos y Escribir, para
	  no mezclar las funciones de la vista (en este caso la consola), con el dominio
	  (librera CMatrix), de tal manera que la libreria CMatrix se pueda usar en mltiples
	  vistas, que no necesariamente ser la consola
	- Los mtodos IngresarElementos y Escribir son declarados como funciones globales en
	  el archivo ejemplo.cpp, para ingresar los datos de la matriz
	- El mtodo InvGauss de CMatriz 1.4 se renombra a InvGaussJordan2
	- Se agrega el mtodo InvGaussJordan1, el cual era un programa independiente que
	  ahora pasa a integrar la libreria CMatrix
	- Se agrega el mtodo InvGaussJordan3, el cual era un programa independiente que ahora
	  pasa a integrar la libreria CMatrix. Este programa se agrega en conjunto con los
	  mtodos privados escalonada e inversa, los cuales son funciones recursivas que son
	  invocados por InvGaussJordan3.
	- Ahora los mtodos InvGaussJordan2 e InvGaussJordan3, permiten calcular
	  simultaneamente la matriz inversa y el determinante, de la matriz original
	- Se corrige algunos bugs en InvGaussJordan2, InvGaussJordan3, que no permitian el
	  correcto clculo de la matriz inversa y adems se agrega una validacin de
	  consistencia de la diagonal de la matriz G pivoteada (G izquierdo), de tal manera
	  que ningn elemento de la diagonal de G izquierdo deba ser cero, caso contrario
	  la matriz no es inversible. De esta manera estas funciones retornan un booleano
	  indicando si se pudo realizar el clculo de la matriz inversa
	- Se agrega el mtodo privado IsZero, usando un delta pequeo, para verificar si
	  una variable es cero, ya que anteriormente se usaba el operador X==0 para verificar
	  si una variable es cero, lo cual podra dar resultados no esperados.
	- Se actualiza el historial de versiones y los crditos
	- Se agregan traducciones del espaol al ingles en el historial de versiones
	- Se eliminan archivos obsoletos
	- Se traducen algunos mtodos y variables miembro del espaol al ingles
	- Se corrige bug en el clculo del signo del determinante en los mtodos
	  InvGaussJordan2 e InvGaussJordan3
	- Se elimina el ejemplo comentado por defecto de la clase CMatrix, ya que qued
	  obsoleto. Sugerimos ver el archivo example.cpp, para ver un completo ejemplo
	  sobre el uso de CMatrix

 >> Version 1.4.1 - 31-X-2000
	- InvGaussJordan1: Tercera versin de la implementacin del
	  algoritmo del clculo de la matriz inversa por el mtodo de Gauss-Jordan.
	  Se mejora la forma en la que se realiza el pivoteo de la matriz ampliada.
	- Este algoritmo se crea como un programa independiente llamado "Inversa"
	  y nunca lleg a ser integrado CMatriz

 >> Version 1.4 - 17-VIII-2000
	- Ya hace mas de un ao que no actualizaba CMatrix, antes que todo pido
	  disculpas a todos los usuarios que usaron CMatrix 1.3 y no pudieron
	  correr el programa en su PC debido a varios errores de compilacin.
	  Esta nueva versin supera varios de los errores que ocurra en
	  CMatrix 1.3.
	  Pero si vuelve a ocurrir algn error, por favor avisarme lo mas
	  rpido posible.
	- Se agrego una nueva funcin miembro: IngresarElementos() ;  que ingresa
	  los elementos de la matriz desde el teclado.
	- Se reemplazo todas las entradas y salidas cout<< y cin>> (de iostream.h)
	  por printf y scanf ( de stdio.h ), para que no ocurran errores de
	  compilacin en algunos compiladores antiguos.
	- Se agregaron comentarios a las lneas de Cdigo mas importantes.

  >> Version 1.3.1 - 06-VI-1999
	- Se trabajaron algunos programas independientes para:
		* OBTENER DATOS DE UNA MATRIZ
		Este programa suma las columnas y filas de una matriz, tambien
		calcula la suma de los elementos de la diagonal principal y
		la diagonal secundaria.
		* CALCULO DE LA TRANSPUESTA DE UNA MATRIZ
	- Estos programas nunca fueron integrados a la librera CMatriz

 >> Version 1.3 - 06-VI-1999
	- Se crea la clase CMatriz, como una clase para hacer algebra de matrices.
	  Trabaja con las matrices como si fueran simples variables.
	- Se implementaron los operadores bsicos +, -, negativo de una matriz,
	  * escalar y * matricial
	- Se agregaron InvGaussJordan2, InvCofact e DetCofact como funciones
	  globales, para que se pueda hacer operaciones adicionales entre matrices.

>> Version 0.4 - 28-II-1999
	- InvGaussJordan3: Inicialmente llamado INVRECU (Inversa Recursiva):
	  Segunda versin de la implementacin del algoritmo del clculo de la
	  matriz inversa por el mtodo de Gauss-Jordan. Se toma como base
	  InvGaussJordan2, pero se inserta funciones recursivas en reemplazo de
	  algunos bucles. Esta funcin calcula la inversa de una matriz con
	  funciones recursivas.

>> Version 0.3 - 28-II-1999
	- InvCofact: Inicialmente llamado SINVERSA (Super Inversa):
	  calcula la inversa de la matriz por el metodo de la transpuesta de
	  de la matriz de cofactores:
	  METODO: A^-1 = (1/|A|) * (C)^t
	  donde C = matiz cofactor de A

>> Version 0.2 - 21-I-1999
	- DetCofact: Inicialmente llamado SDETERM (Super Determinante): Esta rutina
	  calcula con facilidad la determinante de matrices de orden de 10x10.
	  Se utiliza el metodo los cofactores de la matriz (pivoteando).
	  Se utiliza recursividad, por lo que el progrma necesita bastante memoria.

>> Version 0.1 - 21-I-1999
	- InvGaussJordan2: Primera versin de la implementacin del
	  algoritmo del clculo de la matriz inversa por el mtodo de Gauss-Jordan

***********************************************************************************/

#include <vector>

class CMatrix
{
private:
	typedef double ELEMENT;
	typedef std::vector<ELEMENT> ROW;
	typedef std::vector<ROW> MATRIX;

public:
	
	//CONSTRUCTORES
	CMatrix(); //constuye una matriz cuadrada de orden _MAX
	CMatrix(int rows, int cols); //constructor para matrices no cuadradas	
	CMatrix(int order); //constructor para matrices cuadradas
	~CMatrix(); //destructor

	//FUNCIONES
/*private:
	void Inicializar(double elemento); //Copia a todos los elementos
					   //de la matriz el valor
					   //de la variable elemento

	void IngresarElementos();//Se ingresan los elementos de la matriz
				 //desde el teclado
	void Escribir(); //Escribe la matriz en pantalla
	*/
public:
	
	//retorna el numero de filas de la matriz
	int Rows() const;
	
	//retorna el numero de columnas de la matriz
	int Cols() const;

	//retorna el orden de la matriz en caso de ser una
	// matriz cuadrada y en caso contrario retorna -1
	int Order() const;

	//DEFINE LAS OPERACIONES ENTRE MATRICES
	friend CMatrix operator -(const CMatrix &A); 		 //operacion -A  NEGATIVO DE UNA MATRIZ
	friend CMatrix operator +(const CMatrix &A, const CMatrix &B); //operacin A+B SUMA DE MATRICES
	friend CMatrix operator -(const CMatrix &A, const CMatrix &B); //operacin A-B RESTA DE MATRICES
	friend CMatrix operator *(const double& k, const CMatrix &A);  //operacin k*B (k es una constante)
	friend CMatrix operator *(const CMatrix &A, const CMatrix &B);//operacin A*B (Producto matricial)


	// MTODOS
private:
	double DetCofact(const CMatrix & A, const int & orden) const;
	
	//Se reduce la matriz por operaciones elementales comenzando por G[0][0]
	//a una matriz triangular superior
	void escalonada(MATRIX& A, const unsigned int& orden, ELEMENT& Determinant, const int & osm) const;

	//Se reduce la matriz triangular superior de la izquierda de G
	//a una matriz identidad
	void inversa(MATRIX & A, const unsigned int & orden, const int & osm) const;
	
	static bool IsZero(const ELEMENT& element);

public:
	CMatrix Transposed() const;
	double DetCofact() const;	
	bool InvCofact(CMatrix& Inverse) const;

	//CALCULA LA INVERSA DE LA MATRIZ POR EL METODO DE REDUCCION GAUSSIANA (Mtodo 1)
	// (Este mtodo tambin calcula la determinante)
	// A^-1 = { A^-1 ; tal que  G = [ A | I ] = [ I | A^-1 ]  }
	bool InvGaussJordan1(CMatrix & Inverse) const;


	//CALCULA LA INVERSA DE LA MATRIZ POR EL METODO DE REDUCCION GAUSSIANA (Mtodo 2)
	// (Este mtodo tambin calcula la determinante)
	// A^-1 = { A^-1 ; tal que  G = [ A | I ] = [ I | A^-1 ]  }
	bool InvGaussJordan2(CMatrix& Inverse, ELEMENT& Determinant) const;	


	//CALCULA LA INVERSA DE LA MATRIZ POR EL METODO DE REDUCCION GAUSSIANA (Mtodo 2 recursivo)
	// A^-1 = { A^-1 ; tal que  G = [ A | I ] = [ I | A^-1 ]  }
	bool InvGaussJordan3(CMatrix & Inverse, ELEMENT& Determinant) const;

private:
	//VARIABLES MIEMBRO
	int _Rows;
	int _Cols;
	int _Order;
public:
	MATRIX Element; //Contiene los elementos de la matriz
};