/*
 * Decompiled with CFR 0.152.
 */
package cescarabajo;

import cescarabajo.PLANOCOMPLEJO;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;

public class CEscarabajo
extends JFrame
implements MouseListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private int nAncho = 640;
    private int nAlto = 480;
    private double dDIVERGE = 4.0;
    private int nITERMAX = 255;
    private int nPaletaR = 10;
    private int nPaletaG = 5;
    private int nPaletaB = 1;
    public PLANOCOMPLEJO PlanoComplejo = new PLANOCOMPLEJO();
    private BufferedImage canvas;

    public CEscarabajo() {
        this.PlanoComplejo.xmin = -2.0;
        this.PlanoComplejo.xmax = 1.0;
        this.PlanoComplejo.ymin = -1.2;
        this.PlanoComplejo.ymax = 1.2;
        this.canvas = new BufferedImage(this.nAncho, this.nAlto, 1);
    }

    private void Mandelbrot() {
        double Cr_delta = (this.PlanoComplejo.xmax - this.PlanoComplejo.xmin) / (double)this.nAncho;
        double Ci_delta = (this.PlanoComplejo.ymax - this.PlanoComplejo.ymin) / (double)this.nAlto;
        double Ci = this.PlanoComplejo.ymax;
        int j = 0;
        while (j < this.nAlto) {
            double Cr = this.PlanoComplejo.xmin;
            int i = 0;
            while (i < this.nAncho) {
                double Zr = 0.0;
                double Zi = 0.0;
                double Tr = 0.0;
                double Ti = 0.0;
                int nITERACION = 0;
                while (nITERACION < this.nITERMAX && Tr + Ti <= this.dDIVERGE) {
                    Zi = 2.0 * Zr * Zi + Ci;
                    Zr = Tr - Ti + Cr;
                    Tr = Zr * Zr;
                    Ti = Zi * Zi;
                    ++nITERACION;
                }
                if (nITERACION != this.nITERMAX) {
                    int nColor = nITERACION + 50;
                    int r = this.nPaletaR * (nColor + 1) % 256;
                    int g = this.nPaletaG * (nColor + 1) % 256;
                    int b = this.nPaletaB * (nColor + 1) % 256;
                    Color col = new Color(r, g, b);
                    this.canvas.setRGB(i, this.nAlto - j - 1, col.getRGB());
                } else {
                    this.canvas.setRGB(i, this.nAlto - j - 1, 0);
                }
                Cr += Cr_delta;
                ++i;
            }
            Ci -= Ci_delta;
            ++j;
        }
    }

    private void Zoom(double x1, double y1, double x2, double y2) {
        double xmed = 0.5 * (x2 + x1);
        double ymed = 0.5 * (y2 + y1);
        double Lx = 0.5 * Math.abs(x2 - x1);
        double Ly = (double)this.nAlto * Lx / (double)this.nAncho;
        double ex = (this.PlanoComplejo.xmax - this.PlanoComplejo.xmin) / (double)this.nAncho;
        double ey = (this.PlanoComplejo.ymax - this.PlanoComplejo.ymin) / (double)this.nAlto;
        this.PlanoComplejo.xmin += (xmed - Lx) * ex;
        this.PlanoComplejo.ymax -= (ymed - Ly) * ey;
        this.PlanoComplejo.xmax = this.PlanoComplejo.xmin + 2.0 * Lx * ex;
        this.PlanoComplejo.ymin = this.PlanoComplejo.ymax - 2.0 * Ly * ey;
    }

    private void OnMouseClick(int nButton, int nMousex, int nMousey) {
        if (nButton == 1) {
            double dSemiAnchoZoom = (double)this.nAncho * 0.25;
            double dSemiAltoZoom = (double)this.nAlto * 0.25;
            this.Zoom((double)nMousex - dSemiAnchoZoom, (double)(this.nAlto - nMousey) - dSemiAltoZoom, (double)nMousex + dSemiAnchoZoom, (double)(this.nAlto - nMousey) + dSemiAltoZoom);
        } else if (nButton == 3) {
            double dSemiAnchoZoom = this.nAncho;
            double dSemiAltoZoom = this.nAlto;
            this.Zoom((double)nMousex - dSemiAnchoZoom, (double)(this.nAlto - nMousey) - dSemiAltoZoom, (double)nMousex + dSemiAnchoZoom, (double)(this.nAlto - nMousey) + dSemiAltoZoom);
        }
        this.Draw();
    }

    public void Draw() {
        this.Mandelbrot();
        this.repaint();
    }

    public void Display() {
        this.setTitle("Mandelbrot Set");
        this.setBounds(0, 0, this.nAncho, this.nAlto);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.Draw();
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(this.canvas, 0, 0, this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.OnMouseClick(e.getButton(), e.getX(), e.getY());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        int key = ke.getKeyCode();
        if (key == 27 || key == 10) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }
}

