/*
 * Decompiled with CFR 0.152.
 */
package bdescarabajo;

import bdescarabajo.FRACTAL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class BDEscarabajo {
    private static Connection conn;

    public BDEscarabajo() {
        try {
            this.AbrirBD();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void AbrirBD() throws SQLException {
        try {
            Class.forName("org.sqlite.JDBC");
            conn = DriverManager.getConnection("jdbc:sqlite:BDEscarabajo.db");
            if (conn != null) {
                conn.getMetaData();
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void Cerrar() {
        try {
            conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public int RegistrarUsuario(String nombre, String clave) {
        try {
            PreparedStatement ps = conn.prepareStatement("INSERT INTO TablaUsuario VALUES(NULL, ?, ?)");
            ps.setString(1, nombre);
            ps.setString(2, clave);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            if (rs.next()) {
                return rs.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int ValidarUsuario(String nombre, String clave) {
        try {
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM TablaUsuario WHERE nombreUsuario = ? AND contrasenia = ?");
            ps.setString(1, nombre);
            ps.setString(2, clave);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return rs.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public void GuardarFractal(int nIdUsuario, String sNombre, String sDescripcion, double dXmin, double dXmax, double dYmin, double dYmax) {
        try {
            PreparedStatement ps = conn.prepareStatement("INSERT INTO TablaFractal VALUES(NULL, ?, ?, ?, ?, ?, ?, ? )");
            ps.setInt(1, nIdUsuario);
            ps.setString(2, sNombre);
            ps.setString(3, sDescripcion);
            ps.setDouble(4, dXmin);
            ps.setDouble(5, dXmax);
            ps.setDouble(6, dYmin);
            ps.setDouble(7, dYmax);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void ListarFractales(int nIdUsuario, Vector<FRACTAL> vFractales) {
        try {
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM TablaFractal WHERE idUsuario = ?");
            ps.setInt(1, nIdUsuario);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                FRACTAL mFractal = new FRACTAL();
                mFractal.sNombre = rs.getString(3);
                mFractal.sDescripcion = rs.getString(4);
                mFractal.dXmin = rs.getDouble(5);
                mFractal.dXmax = rs.getDouble(6);
                mFractal.dYmin = rs.getDouble(7);
                mFractal.dYmax = rs.getDouble(8);
                vFractales.add(mFractal);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

