/*
 * Decompiled with CFR 0.152.
 */
package interfaz;

import bdescarabajo.BDEscarabajo;
import bdescarabajo.FRACTAL;
import cescarabajo.CEscarabajo;
import java.io.Console;
import java.util.Scanner;
import java.util.Vector;

public class Interfaz {
    private int m_nIdUsuario = 0;
    private String m_sNombre;
    private CEscarabajo m_GraficadorFractal;
    private BDEscarabajo m_bd;
    Scanner m_scan = new Scanner(System.in);

    public Interfaz() {
        this.m_GraficadorFractal = new CEscarabajo();
        this.m_bd = new BDEscarabajo();
    }

    public void Login() {
        while (true) {
            String cOp;
            this.cls();
            System.out.println("Welcome to the \n'FRACTAL MANDELBROT BEETLE' Plotter\n");
            System.out.println("MENU");
            System.out.println("1. Login");
            System.out.println("2. Register");
            System.out.println("3. Exit");
            System.out.print("Choose an option -> ");
            switch (cOp = this.m_scan.next()) {
                case "1": {
                    this.ILogin();
                    return;
                }
                case "2": {
                    this.IRegistrarUsuario();
                    return;
                }
                case "3": {
                    this.m_bd.Cerrar();
                    return;
                }
            }
        }
    }

    private void InterfazPrincipal() {
        block10: while (true) {
            String cOp;
            this.cls();
            System.out.println("Welcome " + this.m_sNombre + "\n");
            System.out.println("Select an option:\n");
            System.out.println("1. Plot new fractal");
            System.out.println("2. Plot your favorite fractals");
            System.out.println("3. Logout");
            System.out.print("Choose an option -> ");
            switch (cOp = this.m_scan.next()) {
                case "1": {
                    this.GraficarFractal(true);
                    return;
                }
                case "2": {
                    FRACTAL mFractal = this.ListarFractales();
                    if (mFractal == null) continue block10;
                    this.m_GraficadorFractal.PlanoComplejo.xmin = mFractal.dXmin;
                    this.m_GraficadorFractal.PlanoComplejo.xmax = mFractal.dXmax;
                    this.m_GraficadorFractal.PlanoComplejo.ymin = mFractal.dYmin;
                    this.m_GraficadorFractal.PlanoComplejo.ymax = mFractal.dYmax;
                    this.GraficarFractal(false);
                    return;
                }
                case "3": {
                    this.m_bd.Cerrar();
                    return;
                }
            }
        }
    }

    private void ILogin() {
        this.cls();
        System.out.println("Login\n");
        System.out.print("Enter your name: ");
        this.m_sNombre = this.m_scan.next();
        System.out.print("Enter your password: ");
        String sClave = this.m_scan.next();
        this.m_nIdUsuario = this.m_bd.ValidarUsuario(this.m_sNombre, sClave);
        if (this.m_nIdUsuario == 0) {
            System.out.println("\nUser password is not valid\n");
            this.pausa();
            this.Login();
        } else {
            this.InterfazPrincipal();
        }
    }

    private void IRegistrarUsuario() {
        this.cls();
        System.out.println("User Registration\n");
        System.out.print("Enter your name: ");
        this.m_sNombre = this.m_scan.next();
        System.out.print("Enter your password: ");
        String sClave = this.m_scan.next();
        System.out.print("Save (Yes 'Y' or No 'N')-> ");
        char cOp = this.m_scan.next().charAt(0);
        if (cOp == 'Y' || cOp == 'y') {
            this.m_nIdUsuario = this.m_bd.RegistrarUsuario(this.m_sNombre, sClave);
            this.InterfazPrincipal();
        } else {
            this.Login();
        }
    }

    private void GraficarFractal(Boolean bMostrarInstrucciones) {
        if (bMostrarInstrucciones.booleanValue()) {
            this.cls();
            System.out.println("INSTRUCTIONS:\n");
            System.out.println("...The 'Mandelbrot Beetle' fractal will then be plotted in a new window");
            System.out.println("The Beetle is a theoretically 'infinite' zoom image, dare you find the limits!...\n");
            System.out.println("1. Use left click to zoom in and right click to zoom out\n");
            System.out.println("2. Press ENTER or ESC key to finish and save your current image to favorite fractals\n");
            System.out.print("Have you read the instructions? (Yes 'Y' or No 'N')-> ");
            char cOp = this.m_scan.next().charAt(0);
            if (cOp == 'Y' || cOp == 'y') {
                this.m_GraficadorFractal.Display();
                this.GuardarFractal();
                this.Salir();
            }
        } else {
            this.m_GraficadorFractal.Display();
            this.GuardarFractal();
            this.Salir();
        }
    }

    private Boolean GuardarFractal() {
        this.cls();
        System.out.print("Do you want to save the fractal to favorites? (Yes 'Y' or No 'N')-> ");
        char cOp = this.m_scan.next().charAt(0);
        if (cOp == 'Y' || cOp == 'y') {
            System.out.println("Save the fractal:");
            System.out.print("Enter fractal name: ");
            String sNombreFractal = this.m_scan.next();
            System.out.print("Enter a description for your fractal: ");
            String sDescripcion = this.m_scan.next();
            this.m_bd.GuardarFractal(this.m_nIdUsuario, sNombreFractal, sDescripcion, this.m_GraficadorFractal.PlanoComplejo.xmin, this.m_GraficadorFractal.PlanoComplejo.xmax, this.m_GraficadorFractal.PlanoComplejo.ymin, this.m_GraficadorFractal.PlanoComplejo.ymax);
            System.out.println("\nYour fractal has been saved in the database...\n");
            this.pausa();
            return true;
        }
        return false;
    }

    private FRACTAL ListarFractales() {
        Vector<FRACTAL> vFractales = new Vector<FRACTAL>();
        FRACTAL mFractal = null;
        this.m_bd.ListarFractales(this.m_nIdUsuario, vFractales);
        int nFractales = vFractales.size();
        this.cls();
        if (nFractales == 0) {
            System.out.println("There are no favorite fractals, please create a new one with the 'Plot new fractal' option");
            mFractal = null;
        } else {
            int i = 0;
            while (i < nFractales) {
                mFractal = vFractales.get(i);
                String sNumero = String.format("%02d", i + 1);
                System.out.println(String.valueOf(sNumero) + ". " + mFractal.sNombre + " : '" + mFractal.sDescripcion + "'");
                ++i;
            }
            System.out.print("Choose an option -> ");
            int nOp = Interfaz.SuperParse(this.m_scan.next());
            if (1 > nOp || nOp > vFractales.size()) {
                System.out.println("The selected option does not exist!");
                mFractal = null;
            } else {
                mFractal = vFractales.get(nOp - 1);
            }
        }
        this.pausa();
        return mFractal;
    }

    private void Salir() {
        this.cls();
        System.out.println("\nThank you for using Beetle...");
        this.pausa();
        this.m_bd.Cerrar();
        System.exit(0);
    }

    private void pausa() {
        Console c = System.console();
        if (c != null) {
            c.format("Press ENTER to continue . . .", new Object[0]);
            c.readLine();
        }
    }

    private void cls() {
        try {
            if (System.getProperty("os.name").contains("Windows")) {
                new ProcessBuilder("cmd", "/c", "cls").inheritIO().start().waitFor();
            } else {
                Runtime.getRuntime().exec("clear");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int SuperParse(String input) {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

